/*
 * Decompiled with CFR 0.152.
 */
package net.rocketplatform.game.client.mod.ui.variable;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import net.rocketplatform.client.generated.BoolContextValue;
import net.rocketplatform.client.generated.ContextValue;
import net.rocketplatform.client.generated.IntContextValue;
import net.rocketplatform.client.generated.StringContextValue;
import net.rocketplatform.game.client.mod.RocketClientMod;
import net.rocketplatform.game.client.mod.ui.variable.VariableStorage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GlobalVariables {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GlobalVariables.class);
    private final Map<String, Object> globalVariables = new HashMap<String, Object>();

    public void populate(VariableStorage storage) {
        RocketClientMod mod = RocketClientMod.getInstance();
        storage.store("modpackId", mod.getModpackId());
        storage.store("packId", mod.getPackMetadata().getId());
        storage.store("version", mod.getPackMetadata().getVersion().getName());
        storage.store("versionId", Integer.toString(mod.getPackMetadata().getVersion().getId()));
        this.globalVariables.forEach(storage::store);
    }

    public void update(@Nullable List<@NotNull ContextValue> contextValues) {
        if (contextValues == null) {
            return;
        }
        contextValues.forEach(contextValue -> {
            if (contextValue instanceof IntContextValue) {
                IntContextValue intContextValue = (IntContextValue)contextValue;
                this.update(intContextValue.getKey(), intContextValue.getIntValue());
            } else if (contextValue instanceof BoolContextValue) {
                BoolContextValue boolContextValue = (BoolContextValue)contextValue;
                this.update(boolContextValue.getKey(), boolContextValue.getBoolValue());
            } else if (contextValue instanceof StringContextValue) {
                StringContextValue stringContextValue = (StringContextValue)contextValue;
                this.update(stringContextValue.getKey(), stringContextValue.getStringValue());
            }
        });
    }

    private void update(@NotNull String key, @NotNull Object value) {
        log.trace("Updating global variable: {} -> {}", (Object)key, value);
        this.globalVariables.put(key, value);
    }
}

