/*
 * Decompiled with CFR 0.152.
 */
package net.rocketplatform.game.client.mod.ui.template.layout.type;

import com.google.gson.annotations.SerializedName;
import com.mojang.blaze3d.vertex.PoseStack;
import dev.ftb.mods.ftblibrary.ui.BaseScreen;
import dev.ftb.mods.ftblibrary.ui.ContextMenu;
import dev.ftb.mods.ftblibrary.ui.Panel;
import dev.ftb.mods.ftblibrary.ui.ScreenWrapper;
import dev.ftb.mods.ftblibrary.ui.Theme;
import dev.ftb.mods.ftblibrary.ui.Widget;
import dev.ftb.mods.ftblibrary.ui.input.Key;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.rocketplatform.game.client.mod.RocketClientMod;
import net.rocketplatform.game.client.mod.ui.template.element.ElementTemplate;
import net.rocketplatform.game.client.mod.ui.template.element.WidgetElementTemplate;
import net.rocketplatform.game.client.mod.ui.template.layout.LayoutTemplate;
import net.rocketplatform.game.client.mod.ui.template.layout.screen.ModalCompatibleBaseScreen;
import net.rocketplatform.game.client.mod.ui.template.layout.screen.TemplateScreen;
import net.rocketplatform.game.client.mod.ui.variable.VariableStorage;
import org.jetbrains.annotations.Nullable;

public class SimpleLayoutTemplate
extends LayoutTemplate {
    @SerializedName(value="render_background")
    private Boolean renderBackground;

    public SimpleLayoutTemplate(String type, String id, Component title, List<ElementTemplate<?>> buttons) {
        super(type, id, title, buttons);
    }

    @Override
    public Screen createScreen0(@Nullable VariableStorage storage) {
        SimpleScreen screen = this.createScreen(this.getTitle(), this);
        if (storage != null) {
            screen.storage.inherit(storage, false);
        }
        screen.openContextMenu((Panel)((ContextMenu)null));
        this.onOpen(screen, screen.storage);
        return new ScreenWrapper((BaseScreen)screen);
    }

    public SimpleScreen createScreen(Component component, SimpleLayoutTemplate template) {
        return new SimpleScreen(component, template);
    }

    public static class SimpleScreen
    extends ModalCompatibleBaseScreen
    implements TemplateScreen {
        private final List<Runnable> closeCallbacks = new ArrayList<Runnable>();
        private final Component title;
        private final SimpleLayoutTemplate template;
        private final VariableStorage storage;
        private int lastRefresh;

        protected SimpleScreen(Component title, SimpleLayoutTemplate template) {
            this.title = title;
            this.template = template;
            this.storage = new VariableStorage(template);
        }

        public void tick() {
            super.tick();
            if (this.template.getRefreshRate() <= 0) {
                return;
            }
            int refreshRate = this.template.getRefreshRate() * 20;
            if (this.lastRefresh >= refreshRate) {
                this.lastRefresh = 0;
                this.refresh();
            } else {
                ++this.lastRefresh;
            }
        }

        @Override
        public void refresh() {
            if (!this.template.onRefresh(this, this.storage)) {
                this.refreshWidgets();
            }
        }

        public boolean onInit() {
            return this.setFullscreen();
        }

        public void onBack() {
            if (this.template.getBack() == null) {
                super.onBack();
            } else {
                this.template.getBack().onPress(this, null, this.storage);
            }
        }

        @Override
        public void onClosed() {
            super.onClosed();
            for (Runnable callback : this.closeCallbacks) {
                try {
                    callback.run();
                }
                catch (Throwable t) {
                    RocketClientMod.getLogger().error("An error occurred processing close callback for screen {}", (Object)this.template.getId(), (Object)t);
                }
            }
            this.closeCallbacks.clear();
        }

        public void onClose(Runnable runnable) {
            this.closeCallbacks.add(runnable);
        }

        @Override
        public boolean keyPressed(Key key) {
            if (key.esc()) {
                this.onBack();
                return true;
            }
            return super.keyPressed(key);
        }

        public Component getTitle() {
            return this.title;
        }

        public void addWidgets() {
            for (ElementTemplate<?> element : this.template.getElements()) {
                if (!(element instanceof WidgetElementTemplate)) continue;
                WidgetElementTemplate ftbTemplate = (WidgetElementTemplate)element;
                this.add((Widget)ftbTemplate.createElement(this, this.width, this.height, 0, 0, this.storage));
            }
        }

        @Override
        public void alignWidgets() {
            for (Widget widget : this.widgets) {
                if (!(widget instanceof Panel)) continue;
                Panel panel = (Panel)widget;
                panel.alignWidgets();
            }
        }

        public void drawBackground(PoseStack graphics, Theme theme, int x, int y, int w, int h) {
            if (this.template.renderBackground != null && this.template.renderBackground.booleanValue()) {
                super.drawBackground(graphics, theme, x, y, w, h);
            }
        }

        @Override
        public Minecraft getMinecraft() {
            return Minecraft.m_91087_();
        }

        @Override
        public VariableStorage getStorage() {
            return this.storage;
        }

        @Override
        public int getWidth() {
            return this.width;
        }

        @Override
        public int getHeight() {
            return this.height;
        }

        public BaseScreen getPanel() {
            return this;
        }

        public Theme getTheme() {
            return Theme.DEFAULT;
        }
    }
}

