/*
 * Decompiled with CFR 0.152.
 */
package net.rocketplatform.game.client.mod.ui.template.element.type.text;

import java.util.Map;
import java.util.function.UnaryOperator;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.rocketplatform.game.client.mod.ui.template.element.type.text.CapitalizationFormatter;
import net.rocketplatform.game.client.mod.ui.template.element.type.text.CurrencyFormatter;
import net.rocketplatform.game.client.mod.ui.template.element.type.text.StorageFormatter;

public interface TextFormatter
extends UnaryOperator<Component> {
    public static final Map<String, TextFormatter> FORMATS = Map.of("capitalization", CapitalizationFormatter.INSTANCE, "currency", CurrencyFormatter.INSTANCE, "storage", StorageFormatter.INSTANCE);

    public static Component processComponent(Component input, UnaryOperator<String> textReplacement) {
        MutableComponent result;
        if (input instanceof TextComponent) {
            TextComponent textComponent = (TextComponent)input;
            result = new TextComponent((String)textReplacement.apply(textComponent.m_131292_())).m_6270_(input.m_7383_());
        } else if (input instanceof TranslatableComponent) {
            TranslatableComponent translatableComponent = (TranslatableComponent)input;
            Object[] args = new Object[translatableComponent.m_131329_().length];
            for (int i = 0; i < args.length; ++i) {
                Object oldArg = translatableComponent.m_131329_()[i];
                if (oldArg instanceof Component) {
                    Component component = (Component)oldArg;
                    args[i] = TextFormatter.processComponent(component, textReplacement);
                    continue;
                }
                if (oldArg instanceof String) {
                    String str = (String)oldArg;
                    args[i] = textReplacement.apply(str);
                    continue;
                }
                args[i] = oldArg;
            }
            result = new TranslatableComponent(translatableComponent.m_131328_(), args).m_6270_(input.m_7383_());
        } else {
            return input;
        }
        for (Component sibling : input.m_7360_()) {
            result.m_7220_(TextFormatter.processComponent(sibling, textReplacement));
        }
        return result;
    }
}

