/*
 * Decompiled with CFR 0.152.
 */
package net.rocketplatform.game.client.mod.ui.template.element.type;

import com.google.gson.annotations.SerializedName;
import com.mojang.blaze3d.vertex.PoseStack;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.ui.GuiHelper;
import dev.ftb.mods.ftblibrary.ui.Theme;
import dev.ftb.mods.ftblibrary.ui.Widget;
import dev.ftb.mods.ftblibrary.util.TooltipList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.rocketplatform.client.generated.PlayerModpackServer;
import net.rocketplatform.game.client.mod.RocketClientMod;
import net.rocketplatform.game.client.mod.ui.template.callback.ElementCallback;
import net.rocketplatform.game.client.mod.ui.template.element.ElementTemplate;
import net.rocketplatform.game.client.mod.ui.template.element.WidgetElementTemplate;
import net.rocketplatform.game.client.mod.ui.template.layout.screen.TemplateScreen;
import net.rocketplatform.game.client.mod.ui.variable.VariableStorage;
import net.rocketplatform.game.client.mod.util.Vector2i;

public class StatusLightsTemplate
extends WidgetElementTemplate {
    private static final Component SERVER_ONLINE = new TranslatableComponent("rgp_client.gui.button.online");
    private static final Component SERVER_OFFLINE = new TranslatableComponent("rgp_client.gui.button.offline");
    private static final Component SERVER_UNHEALTHY = new TranslatableComponent("rgp_client.gui.button.unhealthy");
    private static final Component SERVER_STOPPING = new TranslatableComponent("rgp_client.gui.button.stopping");
    private static final Component SERVER_EXPIRED = new TranslatableComponent("rgp_client.gui.button.expired");
    private static final Component SERVER_STARTING = new TranslatableComponent("rgp_client.gui.button.starting");
    private static final Component SERVER_PENDING = new TranslatableComponent("rgp_client.gui.button.pending");
    private static final Icon ON_ICON = Icon.getIcon((ResourceLocation)new ResourceLocation("realms", "textures/gui/realms/on_icon.png"));
    private static final Icon OFF_ICON = Icon.getIcon((ResourceLocation)new ResourceLocation("realms", "textures/gui/realms/off_icon.png"));
    private static final Icon EXPIRED_ICON = Icon.getIcon((ResourceLocation)new ResourceLocation("realms", "textures/gui/realms/expired_icon.png"));
    private static final Icon EXPIRES_SOON_ICON = Icon.getIcon((ResourceLocation)new ResourceLocation("realms", "textures/gui/realms/expires_soon_icon.png")).withUV(0.0f, 0.0f, 10.0f, 28.0f, 20.0f, 28.0f);
    private static final Icon EXPIRES_SOON_ICON_FLASH = Icon.getIcon((ResourceLocation)new ResourceLocation("realms", "textures/gui/realms/expires_soon_icon.png")).withUV(10.0f, 0.0f, 10.0f, 28.0f, 20.0f, 28.0f);
    private static final Icon SHUTTING_DOWN_ICON = Icon.getIcon((ResourceLocation)new ResourceLocation("rgp_client", "textures/gui/icon/shutting_down_icon.png")).withUV(0.0f, 0.0f, 10.0f, 28.0f, 20.0f, 28.0f);
    private static final Icon SHUTTING_DOWN_ICON_FLASH = Icon.getIcon((ResourceLocation)new ResourceLocation("rgp_client", "textures/gui/icon/shutting_down_icon.png")).withUV(10.0f, 0.0f, 10.0f, 28.0f, 20.0f, 28.0f);
    private static final Icon PENDING_ICON = Icon.getIcon((ResourceLocation)new ResourceLocation("rgp_client", "textures/gui/icon/pending_icon.png")).withUV(0.0f, 0.0f, 10.0f, 28.0f, 20.0f, 28.0f);
    private static final Icon PENDING_ICON_FLASH = Icon.getIcon((ResourceLocation)new ResourceLocation("rgp_client", "textures/gui/icon/pending_icon.png")).withUV(10.0f, 0.0f, 10.0f, 28.0f, 20.0f, 28.0f);
    @SerializedName(value="game_server_key")
    private String gameServerKey;

    public StatusLightsTemplate(String type, String id, ElementTemplate.Position position, ElementCallback callback) {
        super(type, id, position, callback);
    }

    public int getWidth() {
        return 10;
    }

    public int getHeight() {
        return 28;
    }

    @Override
    public Widget createElement0(TemplateScreen screen, int elementWidth, int elementHeight, int offsetX, int offsetY, VariableStorage variableStorage) {
        final PlayerModpackServer modpackServer = (PlayerModpackServer)variableStorage.retrieve(this.gameServerKey);
        if (modpackServer == null) {
            RocketClientMod.getLogger().warn("Modpack server not found for key {} in variable storage!", (Object)this.gameServerKey);
            return new Widget(screen.getPanel());
        }
        Vector2i pos = this.getPivot().apply(elementWidth, elementHeight, this.getWidth(), this.getHeight());
        pos.add(offsetX + this.getPosition().x(), offsetY + this.getPosition().y());
        Widget widget = new Widget(screen.getPanel()){

            public void draw(PoseStack graphics, Theme theme, int x, int y, int w, int h) {
                GuiHelper.setupDrawing();
                if (modpackServer.getSuspended().booleanValue()) {
                    StatusLightsTemplate.this.drawExpired(graphics, x, y);
                    return;
                }
                if (modpackServer.getGameServer() == null) {
                    StatusLightsTemplate.this.drawClosed(graphics, x, y);
                    return;
                }
                switch (modpackServer.getGameServer().getState()) {
                    case HEALTHY: {
                        StatusLightsTemplate.this.drawOpen(graphics, x, y);
                        break;
                    }
                    case STOPPED: 
                    case UNHEALTHY: {
                        StatusLightsTemplate.this.drawClosed(graphics, x, y);
                        break;
                    }
                    case STARTING: {
                        StatusLightsTemplate.this.drawStarting(graphics, x, y);
                        break;
                    }
                    case STOPPING: {
                        StatusLightsTemplate.this.drawShuttingDown(graphics, x, y);
                        break;
                    }
                    case PENDING: {
                        StatusLightsTemplate.this.drawPending(graphics, x, y);
                    }
                }
            }

            public void addMouseOverText(TooltipList list) {
                if (modpackServer.getSuspended().booleanValue()) {
                    list.add(SERVER_EXPIRED);
                    super.addMouseOverText(list);
                    return;
                }
                if (modpackServer.getGameServer() == null) {
                    list.add(SERVER_OFFLINE);
                    super.addMouseOverText(list);
                    return;
                }
                switch (modpackServer.getGameServer().getState()) {
                    case HEALTHY: {
                        list.add(SERVER_ONLINE);
                        break;
                    }
                    case STOPPED: {
                        list.add(SERVER_OFFLINE);
                        break;
                    }
                    case UNHEALTHY: {
                        list.add(SERVER_UNHEALTHY);
                        break;
                    }
                    case STOPPING: {
                        list.add(SERVER_STOPPING);
                        break;
                    }
                    case STARTING: {
                        list.add(SERVER_STARTING);
                        break;
                    }
                    case PENDING: {
                        list.add(SERVER_PENDING);
                    }
                }
                super.addMouseOverText(list);
            }
        };
        widget.setPosAndSize(pos.x(), pos.y(), this.getWidth(), this.getHeight());
        return widget;
    }

    private void drawExpired(PoseStack guiGraphics, int x, int y) {
        EXPIRED_ICON.draw(guiGraphics, x, y, this.getWidth(), this.getHeight());
    }

    private void drawStarting(PoseStack guiGraphics, int x, int y) {
        long animTick = System.currentTimeMillis() / 50L % 20L;
        if (animTick < 10L) {
            EXPIRES_SOON_ICON_FLASH.draw(guiGraphics, x, y, this.getWidth(), this.getHeight());
        } else {
            EXPIRES_SOON_ICON.draw(guiGraphics, x, y, this.getWidth(), this.getHeight());
        }
    }

    private void drawShuttingDown(PoseStack guiGraphics, int x, int y) {
        long animTick = System.currentTimeMillis() / 50L % 20L;
        if (animTick < 10L) {
            SHUTTING_DOWN_ICON_FLASH.draw(guiGraphics, x, y, this.getWidth(), this.getHeight());
        } else {
            SHUTTING_DOWN_ICON.draw(guiGraphics, x, y, this.getWidth(), this.getHeight());
        }
    }

    private void drawPending(PoseStack guiGraphics, int x, int y) {
        long animTick = System.currentTimeMillis() / 50L % 20L;
        if (animTick < 10L) {
            PENDING_ICON_FLASH.draw(guiGraphics, x, y, this.getWidth(), this.getHeight());
        } else {
            PENDING_ICON.draw(guiGraphics, x, y, this.getWidth(), this.getHeight());
        }
    }

    private void drawOpen(PoseStack guiGraphics, int x, int y) {
        ON_ICON.draw(guiGraphics, x, y, this.getWidth(), this.getHeight());
    }

    private void drawClosed(PoseStack guiGraphics, int x, int y) {
        OFF_ICON.draw(guiGraphics, x, y, this.getWidth(), this.getHeight());
    }
}

