/*
 * Decompiled with CFR 0.152.
 */
package net.rocketplatform.game.client.mod.ui.template.callback.type;

import com.google.gson.annotations.SerializedName;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.ConnectScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.client.multiplayer.resolver.ServerAddress;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.rocketplatform.client.generated.GameServer;
import net.rocketplatform.client.generated.GameServerState;
import net.rocketplatform.client.generated.OnlineGameServerInfo;
import net.rocketplatform.client.generated.PlayerModpackServer;
import net.rocketplatform.game.client.mod.RocketClientMod;
import net.rocketplatform.game.client.mod.ui.FTBWorldsButton;
import net.rocketplatform.game.client.mod.ui.MultilineErrorScreen;
import net.rocketplatform.game.client.mod.ui.template.callback.CallbackHolder;
import net.rocketplatform.game.client.mod.ui.template.callback.ElementCallback;
import net.rocketplatform.game.client.mod.ui.template.layout.LayoutTemplate;
import net.rocketplatform.game.client.mod.ui.template.layout.screen.TemplateScreen;
import net.rocketplatform.game.client.mod.ui.variable.VariableProcessor;
import net.rocketplatform.game.client.mod.ui.variable.VariableStorage;
import org.jetbrains.annotations.Nullable;

public class PlayCallback
extends ElementCallback {
    @SerializedName(value="loading_screen")
    private LayoutTemplate loadingScreen;
    private String name;
    private String address;

    public PlayCallback(String action) {
        super(action);
    }

    @Override
    public void onPress(TemplateScreen screen, @Nullable CallbackHolder holder, final VariableStorage variableStorage) {
        if (!variableStorage.contains("gameServerId")) {
            this.handleFailure("Unable to join server: Could not find game server id.", null, new Throwable());
            return;
        }
        final String gameServerId = (String)variableStorage.retrieve("gameServerId");
        int versionId = Integer.parseInt((String)variableStorage.retrieve("versionId"));
        ((CompletableFuture)RocketClientMod.getInstance().getClientHandler().thenCompose(client -> client.getPlayerServerVersion(gameServerId).whenComplete((playerServer, e) -> {
            if (e != null) {
                this.handleFailure("Unable to join server: An error occurred retrieving the server version.", gameServerId, (Throwable)e);
                return;
            }
            if (playerServer == null) {
                this.handleFailure("Unable to join server: Failed to retrieve the server version.", gameServerId, new Throwable());
                return;
            }
            if (!playerServer.getModpackId().equals(RocketClientMod.getInstance().getModpackId())) {
                this.handleFailure("Unable to join server: Invalid modpack! The server is not running the same modpack as you.", gameServerId, new Throwable());
                return;
            }
            GameServer gameServer = playerServer.getGameServer();
            if (gameServer == null) {
                this.handleFailure("Unable to join server: Failed to retrieve game server instance.", gameServerId, new Throwable());
                return;
            }
            OnlineGameServerInfo info = gameServer.getInfo();
            if (info != null) {
                variableStorage.store("serverIp", info.getIp());
                variableStorage.store("serverPort", info.getPort());
                variableStorage.store("joinable", (gameServer.getState() == GameServerState.HEALTHY || gameServer.getState() == GameServerState.STARTING || gameServer.getState() == GameServerState.STOPPED) && playerServer.getSuspended() == false);
                variableStorage.store("playerCount", info.getOnlineState().getPlayerCount());
            }
            final Screen parentScreen = screen.getMinecraft().f_91080_;
            GameServerState state = gameServer.getState();
            if (state == GameServerState.HEALTHY) {
                if (!this.processOutdatedServer(gameServerId, (PlayerModpackServer)playerServer, versionId)) {
                    return;
                }
                this.joinServer(gameServerId, UUID.fromString(playerServer.getOwnerId()), variableStorage, parentScreen);
                return;
            }
            if (state == GameServerState.STOPPED) {
                int serverVersion = Integer.parseInt(playerServer.getVersionId());
                int clientVersion = RocketClientMod.getInstance().getPackMetadata().getVersion().getId();
                if (clientVersion < serverVersion) {
                    this.handleFailure("Unable to join server: Client outdated! Please update your client to the latest version to join.", gameServerId, new Throwable());
                    return;
                }
                ((CompletableFuture)client.startPlayerServer(playerServer.getGameServerId(), Integer.toString(clientVersion)).thenAccept(response -> {
                    if (response == null) {
                        this.handleFailure("Unable to join server: Failed to start the server.", gameServerId, new Throwable());
                        return;
                    }
                    if (!this.processOutdatedServer(gameServerId, response.getServer(), versionId)) {
                        return;
                    }
                })).whenComplete((ignored, ex) -> {
                    if (ex != null) {
                        this.handleFailure("Unable to join server: An error occurred starting the server.", gameServerId, (Throwable)ex);
                    }
                });
            }
            if (state == GameServerState.STARTING && !this.processOutdatedServer(gameServerId, (PlayerModpackServer)playerServer, versionId)) {
                return;
            }
            final Screen loadingScreen = this.loadingScreen.createScreen(variableStorage);
            if (this.loadingScreen != null) {
                RenderSystem.m_69879_(() -> screen.getMinecraft().m_91152_(loadingScreen));
            }
            final Timer timer = new Timer();
            timer.scheduleAtFixedRate(new TimerTask(){

                @Override
                public void run() {
                    if (Minecraft.m_91087_().f_91080_ != loadingScreen) {
                        timer.cancel();
                        return;
                    }
                    ((CompletableFuture)((CompletableFuture)RocketClientMod.getInstance().getClientHandler().thenCompose(client -> client.getPlayerServerState(gameServerId))).whenComplete((playerServer, e) -> {
                        GameServerState state;
                        if (e != null) {
                            PlayCallback.this.handleFailure("Unable to join server: An error occurred retrieving the server state.", gameServerId, (Throwable)e);
                            return;
                        }
                        if (playerServer == null) {
                            PlayCallback.this.handleFailure("Unable to join server: Failed to retrieve the server state.", gameServerId, new Throwable());
                            return;
                        }
                        GameServer gameServer = playerServer.getGameServer();
                        if (gameServer == null) {
                            PlayCallback.this.handleFailure("Unable to join server: Failed to retrieve game server instance.", gameServerId, new Throwable());
                            return;
                        }
                        OnlineGameServerInfo info = gameServer.getInfo();
                        if (info != null) {
                            variableStorage.store("serverIp", info.getIp());
                            variableStorage.store("serverPort", info.getPort());
                            variableStorage.store("joinable", (gameServer.getState() == GameServerState.HEALTHY || gameServer.getState() == GameServerState.STARTING || gameServer.getState() == GameServerState.STOPPED) && playerServer.getSuspended() == false);
                            variableStorage.store("playerCount", info.getOnlineState().getPlayerCount());
                        }
                        if ((state = gameServer.getState()) == GameServerState.HEALTHY) {
                            PlayCallback.this.joinServer(gameServerId, UUID.fromString(playerServer.getOwnerId()), variableStorage, parentScreen);
                            timer.cancel();
                        }
                    })).whenComplete((ignored, e) -> {
                        if (e != null) {
                            PlayCallback.this.handleFailure("A failure occurred joining the server.", gameServerId, (Throwable)e);
                        }
                    });
                }
            }, 1000L, 5000L);
        }))).exceptionally(e -> {
            this.handleFailure("Unable to join server: An unexpected error occurred when trying to join.", gameServerId, (Throwable)e);
            return null;
        });
    }

    private void joinServer(String gameServerId, UUID ownerId, VariableStorage variableStorage, Screen parentScreen) {
        String address = VariableProcessor.process(this.address, variableStorage);
        RenderSystem.m_69879_(() -> ConnectScreen.m_169267_((Screen)parentScreen, (Minecraft)Minecraft.m_91087_(), (ServerAddress)ServerAddress.m_171864_((String)address), (ServerData)new ServerData(this.name, address, false)));
        RocketClientMod.getInstance().setConnectingToRocketServer(true);
        RocketClientMod.getInstance().setRocketServerId(gameServerId);
        RocketClientMod.getInstance().setRocketServerOwner(ownerId);
    }

    private void handleFailure(String reason, @Nullable String gameServerId, Throwable exception) {
        RocketClientMod.getLogger().error("An error occurred (gameServerId: {}): {}", new Object[]{gameServerId, reason, exception});
        RenderSystem.m_69879_(() -> {
            MultilineErrorScreen errorScreen = new MultilineErrorScreen((Component)new TranslatableComponent("rgp_client.gui.button.ftb_worlds"), (Component)new TextComponent(reason), () -> FTBWorldsButton.openMainScreen(RocketClientMod.getInstance().getClientHandler()));
            Minecraft.m_91087_().m_91152_((Screen)errorScreen);
        });
    }

    private boolean processOutdatedServer(String gameServerId, PlayerModpackServer playerServer, int versionId) {
        int serverVersionId = Integer.parseInt(playerServer.getVersionId());
        if (serverVersionId > versionId) {
            this.handleFailure("Unable to join server: Client outdated! Please update your client to the latest version to join. (" + serverVersionId + ")", gameServerId, new Throwable());
            return false;
        }
        if (serverVersionId < versionId) {
            if (playerServer.getOwnerId().equals(Minecraft.m_91087_().m_91094_().m_92548_().getId().toString())) {
                this.handleFailure("Unable to join server: Server outdated! Please restart the server in order to update it to the latest version. (" + serverVersionId + ")", gameServerId, new Throwable());
                return false;
            }
            this.handleFailure("Unable to join server: Server outdated! Please contact the server owner and ask them to restart the server to join. (" + serverVersionId + ")", gameServerId, new Throwable());
            return false;
        }
        return true;
    }
}

