/*
 * Decompiled with CFR 0.152.
 */
package net.rocketplatform.game.client.mod.ui.loader;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import net.minecraft.network.chat.TranslatableComponent;
import net.rocketplatform.client.generated.ModpackAsset;
import net.rocketplatform.client.generated.ModpackLoadout;
import net.rocketplatform.client.generated.ModpackLoadoutPrice;
import net.rocketplatform.client.generated.ModpackLoadoutPriceCost;
import net.rocketplatform.game.client.mod.RocketClientMod;
import net.rocketplatform.game.client.mod.ui.loader.ListEntryLoader;
import net.rocketplatform.game.client.mod.ui.template.element.ElementTemplate;
import net.rocketplatform.game.client.mod.ui.template.layout.type.AbstractListLayoutTemplate;
import net.rocketplatform.game.client.mod.ui.variable.VariableProcessor;
import net.rocketplatform.game.client.mod.ui.variable.VariableStorage;
import org.jetbrains.annotations.Nullable;

public class ModpackTierEntryLoader
extends ListEntryLoader {
    public ModpackTierEntryLoader(String type, AbstractListLayoutTemplate.ListEntry entryTemplate) {
        super(type, entryTemplate);
    }

    @Override
    public CompletableFuture<List<ListEntryLoader.ListEntryTemplate>> loadEntries(@Nullable VariableStorage storage) {
        String loadoutId;
        AbstractListLayoutTemplate.ListEntry entryTemplate = this.getEntryTemplate();
        String modpackId = RocketClientMod.getInstance().getModpackId();
        String string = loadoutId = storage == null ? null : (String)storage.retrieve("selectedLoadoutId");
        if (loadoutId == null) {
            return CompletableFuture.completedFuture(List.of());
        }
        return ((CompletableFuture)RocketClientMod.getInstance().getClientHandler().thenCompose(client -> client.getModpack(modpackId))).thenApply(modpack -> {
            ArrayList<ListEntryLoader.ListEntryTemplate> entries = new ArrayList<ListEntryLoader.ListEntryTemplate>();
            for (ModpackLoadout loadout : modpack.getLoadouts()) {
                if (!loadout.getLoadoutId().equals(loadoutId)) continue;
                for (ModpackLoadoutPrice price : loadout.getPrices()) {
                    VariableStorage priceStorage = new VariableStorage();
                    priceStorage.store("priceTierName", price.getPricingTier().toString());
                    TranslatableComponent component = new TranslatableComponent("rgp_client.gui.worlds_creation.tier." + price.getPricingTier().toString().toLowerCase(Locale.ROOT));
                    priceStorage.store("priceTierPeriod", component.getString());
                    ModpackLoadoutPriceCost priceCost = price.getPrice();
                    if (priceCost != null) {
                        priceStorage.store("priceCost", priceCost.getPrice());
                        priceStorage.store("priceCurrency", priceCost.getCurrency());
                    } else {
                        priceStorage.store("priceCost", 0);
                        priceStorage.store("priceCurrency", "usd");
                    }
                    ModpackAsset asset = price.getIconAsset();
                    priceStorage.store("priceAssetKey", asset.getAssetKey());
                    priceStorage.store("priceAssetUrl", asset.getDownloadUrl());
                    List<ElementTemplate<?>> elements = ModpackTierEntryLoader.processElements(entryTemplate, priceStorage);
                    AbstractListLayoutTemplate.ListEntry entry = new AbstractListLayoutTemplate.ListEntry(VariableProcessor.process(entryTemplate.getId(), priceStorage), elements, entryTemplate.requiredDoubleClickVariable(), entryTemplate.getCallback(), entryTemplate.selectedCallback());
                    entries.add(new ListEntryLoader.ListEntryTemplate(entry, priceStorage));
                }
            }
            return entries;
        });
    }
}

