/*
 * Decompiled with CFR 0.152.
 */
package net.rocketplatform.game.client.mod.keypair;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.mojang.authlib.Environment;
import com.mojang.authlib.HttpAuthenticationService;
import com.mojang.authlib.exceptions.MinecraftClientException;
import com.mojang.authlib.exceptions.MinecraftClientHttpException;
import com.mojang.authlib.minecraft.client.ObjectMapper;
import com.mojang.authlib.yggdrasil.response.ErrorResponse;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.util.UUIDTypeAdapter;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.PublicKey;
import java.time.DateTimeException;
import java.time.Instant;
import java.util.Base64;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.minecraft.SharedConstants;
import net.minecraft.Util;
import net.minecraft.util.CryptException;
import net.rocketplatform.game.client.mod.RocketClientMod;
import net.rocketplatform.game.client.mod.keypair.CryptUtil;
import net.rocketplatform.game.client.mod.keypair.KeyPairResponse;
import net.rocketplatform.game.client.mod.keypair.ProfileKeyPair;
import net.rocketplatform.game.client.mod.keypair.ProfilePublicKey;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.Nullable;

public class KeypairManager {
    private static final Path PROFILE_KEY_PAIR_DIR = Path.of("profilekeys", new String[0]);
    private final URL routeKeyPair;
    private final Path profileKeyPairPath;
    private final String accessToken;
    private final Proxy proxy;
    private final ObjectMapper objectMapper = new ObjectMapper(new GsonBuilder().registerTypeAdapter(UUID.class, (Object)new UUIDTypeAdapter()).registerTypeHierarchyAdapter(ByteBuffer.class, (Object)new ByteBufferTypeAdapter().nullSafe()).create());
    private CompletableFuture<Optional<ProfileKeyPair>> keyPair;

    public KeypairManager(String accessToken, Proxy proxy, Environment env, UUID uuid, Path path) {
        this.profileKeyPairPath = path.resolve(PROFILE_KEY_PAIR_DIR).resolve(uuid + ".json");
        this.accessToken = accessToken;
        this.proxy = proxy;
        this.keyPair = CompletableFuture.supplyAsync(() -> this.readProfileKeyPair().filter(keyPair -> !keyPair.publicKey().data().hasExpired()), Util.m_183991_()).thenCompose(this::readOrFetchProfileKeyPair);
        this.routeKeyPair = HttpAuthenticationService.constantURL((String)(env.getServicesHost() + "/player/certificates"));
    }

    public CompletableFuture<Optional<ProfileKeyPair>> prepareKeyPair() {
        this.keyPair = this.keyPair.thenCompose(this::readOrFetchProfileKeyPair);
        return this.keyPair;
    }

    private CompletableFuture<Optional<ProfileKeyPair>> readOrFetchProfileKeyPair(Optional<ProfileKeyPair> opKeyPair) {
        return CompletableFuture.supplyAsync(() -> {
            if (opKeyPair.isPresent() && !((ProfileKeyPair)opKeyPair.get()).dueRefresh()) {
                if (!SharedConstants.f_136183_) {
                    this.writeProfileKeyPair(null);
                }
                return opKeyPair;
            }
            try {
                ProfileKeyPair profileKeyPair = this.fetchProfileKeyPair();
                this.writeProfileKeyPair(profileKeyPair);
                return Optional.of(profileKeyPair);
            }
            catch (MinecraftClientException | IOException | CryptException e) {
                RocketClientMod.getLogger().error("Failed to retrieve profile key pair", e);
                this.writeProfileKeyPair(null);
                return opKeyPair;
            }
        }, Util.m_183991_());
    }

    private Optional<ProfileKeyPair> readProfileKeyPair() {
        if (Files.notExists(this.profileKeyPairPath, new LinkOption[0])) {
            return Optional.empty();
        }
        try {
            Optional opKeyPair;
            try (BufferedReader reader = Files.newBufferedReader(this.profileKeyPairPath);){
                opKeyPair = ProfileKeyPair.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)JsonParser.parseReader((Reader)reader)).result();
            }
            return opKeyPair;
        }
        catch (Exception e) {
            RocketClientMod.getLogger().error("Failed to read profile key pair file {}", (Object)this.profileKeyPairPath, (Object)e);
            return Optional.empty();
        }
    }

    private void writeProfileKeyPair(@Nullable ProfileKeyPair keyPair) {
        try {
            Files.deleteIfExists(this.profileKeyPairPath);
        }
        catch (IOException e) {
            RocketClientMod.getLogger().error("Failed to delete profile key pair file {}", (Object)this.profileKeyPairPath, (Object)e);
        }
        if (keyPair != null && SharedConstants.f_136183_) {
            ProfileKeyPair.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)keyPair).result().ifPresent(json -> {
                try {
                    Files.createDirectories(this.profileKeyPairPath.getParent(), new FileAttribute[0]);
                    Files.writeString(this.profileKeyPairPath, (CharSequence)json.toString(), new OpenOption[0]);
                }
                catch (Exception e) {
                    RocketClientMod.getLogger().error("Failed to write profile key pair file {}", (Object)this.profileKeyPairPath, (Object)e);
                }
            });
        }
    }

    private ProfileKeyPair fetchProfileKeyPair() throws CryptException, IOException {
        KeyPairResponse response = this.post(this.routeKeyPair, KeyPairResponse.class);
        if (response != null) {
            ProfilePublicKey.Data data = KeypairManager.parsePublicKey(response);
            return new ProfileKeyPair(CryptUtil.stringToPemRsaPrivateKey(response.keyPair().privateKey()), new ProfilePublicKey(data), Instant.parse(response.refreshedAfter()));
        }
        throw new IOException("Could not retrieve profile key pair");
    }

    private static ProfilePublicKey.Data parsePublicKey(KeyPairResponse response) throws CryptException {
        KeyPairResponse.KeyPair keyPair = response.keyPair();
        if (!StringUtils.isEmpty((CharSequence)keyPair.publicKey()) && response.publicKeySignature() != null && response.publicKeySignature().array().length != 0) {
            try {
                Instant instant = Instant.parse(response.expiresAt());
                PublicKey publicKey = CryptUtil.stringToRsaPublicKey(keyPair.publicKey());
                ByteBuffer keySignature = response.publicKeySignature();
                return new ProfilePublicKey.Data(instant, publicKey, keySignature.array());
            }
            catch (IllegalArgumentException | DateTimeException e) {
                throw new CryptException((Throwable)e);
            }
        }
        throw new CryptException((Throwable)new RuntimeException("Missing public key"));
    }

    private <T> T post(URL url, Class<T> responseClass) {
        Validate.notNull((Object)url);
        Validate.notNull(responseClass);
        HttpURLConnection connection = this.postInternal(url, new byte[0]);
        return this.readInputStream(url, responseClass, connection);
    }

    @Nullable
    private <T> T readInputStream(URL url, Class<T> clazz, HttpURLConnection connection) {
        int status;
        InputStream inputStream;
        block7: {
            String result;
            block8: {
                inputStream = null;
                status = connection.getResponseCode();
                if (status >= 400) break block7;
                inputStream = connection.getInputStream();
                result = IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8);
                if (!result.isEmpty()) break block8;
                T t = null;
                IOUtils.closeQuietly((InputStream)inputStream);
                return t;
            }
            Object object = this.objectMapper.readValue(result, clazz);
            IOUtils.closeQuietly((InputStream)inputStream);
            return (T)object;
        }
        try {
            try {
                inputStream = connection.getErrorStream();
                if (inputStream != null) {
                    String result = IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8);
                    ErrorResponse errorResponse = (ErrorResponse)this.objectMapper.readValue(result, ErrorResponse.class);
                    throw new MinecraftClientHttpException(status, errorResponse);
                }
                throw new MinecraftClientHttpException(status);
            }
            catch (IOException e) {
                throw new MinecraftClientException(MinecraftClientException.ErrorType.SERVICE_UNAVAILABLE, "Failed to read from " + url + " due to " + e.getMessage(), (Throwable)e);
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(inputStream);
            throw throwable;
        }
    }

    private HttpURLConnection postInternal(URL url, byte[] postAsBytes) {
        HttpURLConnection connection = KeypairManager.createUrlConnection(url, this.proxy);
        OutputStream outputStream = null;
        try {
            connection.setRequestProperty("Content-Type", "application/json; charset=utf-8");
            connection.setRequestProperty("Content-Length", "" + postAsBytes.length);
            connection.setRequestProperty("Authorization", "Bearer " + this.accessToken);
            connection.setRequestMethod("POST");
            connection.setDoOutput(true);
            outputStream = connection.getOutputStream();
            IOUtils.write((byte[])postAsBytes, (OutputStream)outputStream);
        }
        catch (IOException io) {
            try {
                throw new MinecraftClientException(MinecraftClientException.ErrorType.SERVICE_UNAVAILABLE, "Failed to POST " + url, (Throwable)io);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(outputStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((OutputStream)outputStream);
        return connection;
    }

    private static HttpURLConnection createUrlConnection(URL url, Proxy proxy) {
        try {
            RocketClientMod.getLogger().debug("Connecting to {}", (Object)url);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection(proxy);
            connection.setConnectTimeout(5000);
            connection.setReadTimeout(5000);
            connection.setUseCaches(false);
            return connection;
        }
        catch (IOException io) {
            throw new MinecraftClientException(MinecraftClientException.ErrorType.SERVICE_UNAVAILABLE, "Failed connecting to " + url, (Throwable)io);
        }
    }

    private static class ByteBufferTypeAdapter
    extends TypeAdapter<ByteBuffer> {
        private ByteBufferTypeAdapter() {
        }

        public void write(JsonWriter out, ByteBuffer value) throws IOException {
            out.value(Base64.getEncoder().encodeToString(value.array()));
        }

        public ByteBuffer read(JsonReader in) throws IOException {
            try {
                return ByteBuffer.wrap(Base64.getDecoder().decode(in.nextString()));
            }
            catch (IllegalArgumentException e) {
                throw new JsonParseException("Malformed base64 string", (Throwable)e);
            }
        }
    }
}

