/*
 * Decompiled with CFR 0.152.
 */
package dev.rdh.createunlimited.lib.delta;

import dev.rdh.createunlimited.lib.delta.SeekableSource;
import java.io.IOException;
import java.nio.ByteBuffer;

public class ByteBufferSeekableSource
implements SeekableSource {
    private ByteBuffer bb;
    private ByteBuffer cur;

    public ByteBufferSeekableSource(byte[] source) {
        this(ByteBuffer.wrap(source));
    }

    public ByteBufferSeekableSource(ByteBuffer bb) {
        if (bb == null) {
            throw new NullPointerException("bb");
        }
        this.bb = bb;
        bb.rewind();
        try {
            this.seek(0L);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void seek(long pos) throws IOException {
        this.cur = this.bb.slice();
        if (pos > (long)this.cur.limit()) {
            throw new IOException("pos " + pos + " cannot seek " + this.cur.limit());
        }
        this.cur.position((int)pos);
    }

    public int read(ByteBuffer dest) throws IOException {
        if (!this.cur.hasRemaining()) {
            return -1;
        }
        int c = 0;
        while (this.cur.hasRemaining() && dest.hasRemaining()) {
            dest.put(this.cur.get());
            ++c;
        }
        return c;
    }

    public void close() throws IOException {
        this.bb = null;
        this.cur = null;
    }

    public String toString() {
        return "BBSeekable bb=" + this.bb.position() + "-" + this.bb.limit() + " cur=" + this.cur.position() + "-" + this.cur.limit() + "";
    }
}

