/*
 * Decompiled with CFR 0.152.
 */
package dev.rdh.createunlimited.lib.classdiff.util;

import dev.rdh.createunlimited.lib.classdiff.UncheckedPatchFailure;
import dev.rdh.createunlimited.lib.classdiff.util.ReflectUtils;
import dev.rdh.createunlimited.lib.difflib.patch.AbstractDelta;
import dev.rdh.createunlimited.lib.difflib.patch.Patch;
import dev.rdh.createunlimited.lib.difflib.patch.PatchFailedException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.function.Supplier;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.LabelNode;

public class Util {
    public static <T> List<T> getListFromArray(List<T>[] array, int i) {
        if (array == null) {
            return Collections.emptyList();
        }
        List<T> value = array[i];
        return Util.nullToEmpty(value);
    }

    public static InsnList clone(InsnList list, Map<LabelNode, LabelNode> clonedLabels) {
        InsnList result = new InsnList();
        for (AbstractInsnNode insn : list) {
            result.add(insn.clone(clonedLabels));
        }
        return result;
    }

    public static InsnList asInsnList(List<AbstractInsnNode> list) {
        InsnList result = new InsnList();
        for (AbstractInsnNode insn : list) {
            result.add(insn);
        }
        return result;
    }

    public static <T> List<T> applyPatchUnchecked(Patch<T> patch, List<T> target) {
        ArrayList<T> result = new ArrayList<T>(target);
        List<AbstractDelta<T>> deltas = patch.getDeltas();
        ListIterator<AbstractDelta<T>> it = deltas.listIterator(deltas.size());
        try {
            while (it.hasPrevious()) {
                ReflectUtils.invokeAbstractDeltaApplyTo(it.previous(), result);
            }
        }
        catch (PatchFailedException e) {
            throw new UncheckedPatchFailure(e);
        }
        return result;
    }

    public static <T> Supplier<T> lazy(final Supplier<T> initializer) {
        return new Supplier<T>(){
            private volatile boolean initialized;
            private T result;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public T get() {
                if (!this.initialized) {
                    1 var1_1 = this;
                    synchronized (var1_1) {
                        if (!this.initialized) {
                            this.result = initializer.get();
                            this.initialized = true;
                        }
                    }
                }
                return this.result;
            }
        };
    }

    public static boolean isNullOrEmpty(List<?> list) {
        return list == null || list.isEmpty();
    }

    public static <T> List<T> nullToEmpty(List<T> list) {
        return list != null ? list : Collections.emptyList();
    }
}

