/*
 * Decompiled with CFR 0.152.
 */
package dev.rdh.createunlimited.lib.classdiff.util;

import dev.rdh.createunlimited.lib.classdiff.util.ByteReader;
import dev.rdh.createunlimited.lib.difflib.patch.AbstractDelta;
import dev.rdh.createunlimited.lib.difflib.patch.ChangeDelta;
import dev.rdh.createunlimited.lib.difflib.patch.Chunk;
import dev.rdh.createunlimited.lib.difflib.patch.DeleteDelta;
import dev.rdh.createunlimited.lib.difflib.patch.DeltaType;
import dev.rdh.createunlimited.lib.difflib.patch.InsertDelta;
import dev.rdh.createunlimited.lib.difflib.patch.Patch;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;

public class PatchReader<T> {
    private final Function<ByteReader, T> reader;

    public PatchReader(Function<ByteReader, T> reader) {
        this.reader = reader;
    }

    private void read(int deltaCount, ByteReader input, Consumer<AbstractDelta<T>> output, List<T> originals) {
        block6: for (int i = 0; i < deltaCount; ++i) {
            DeltaType type = DeltaType.values()[input.readByte()];
            switch (type) {
                case CHANGE: {
                    int position = input.readShort();
                    int sourceLength = input.readShort();
                    int targetLength = input.readShort();
                    ArrayList<T> targetLines = new ArrayList<T>(targetLength);
                    for (int j = 0; j < targetLength; ++j) {
                        targetLines.add(this.reader.apply(input));
                    }
                    output.accept(new ChangeDelta<T>(new Chunk<T>(position, originals.subList(position, position + sourceLength)), new Chunk(0, targetLines)));
                    continue block6;
                }
                case DELETE: {
                    int position = input.readShort();
                    int length = input.readShort();
                    output.accept(new DeleteDelta<T>(new Chunk<T>(position, originals.subList(position, position + length)), new Chunk(0, Collections.emptyList())));
                    continue block6;
                }
                case INSERT: {
                    int position = input.readShort();
                    int targetLength = input.readShort();
                    ArrayList<T> targetLines = new ArrayList<T>(targetLength);
                    for (int j = 0; j < targetLength; ++j) {
                        targetLines.add(this.reader.apply(input));
                    }
                    output.accept(new InsertDelta(new Chunk(position, Collections.emptyList()), new Chunk(0, targetLines)));
                    continue block6;
                }
                case EQUAL: {
                    continue block6;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
        }
    }

    public List<AbstractDelta<T>> readDeltaList(ByteReader input, List<T> originals) {
        int deltaCount = input.readShort();
        ArrayList<AbstractDelta<T>> result = new ArrayList<AbstractDelta<T>>(deltaCount);
        this.read(deltaCount, input, result::add, originals);
        return result;
    }

    public Patch<T> readPatch(ByteReader input, List<T> originals) {
        int deltaCount = input.readShort();
        Patch result = new Patch(deltaCount);
        this.read(deltaCount, input, result::addDelta, originals);
        return result;
    }
}

