/*
 * Decompiled with CFR 0.152.
 */
package dev.rdh.createunlimited.lib.classdiff.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.RecordComponentNode;

public class MemberName {
    public final String name;
    public final String descriptor;

    public MemberName(String name, String descriptor) {
        this.name = name;
        this.descriptor = descriptor;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MemberName)) {
            return false;
        }
        MemberName that = (MemberName)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.descriptor, that.descriptor);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.descriptor);
    }

    public String toString() {
        if (this.descriptor.startsWith("(")) {
            return this.name + this.descriptor;
        }
        return this.name + ':' + this.descriptor;
    }

    public static MemberName fromRecordComponent(RecordComponentNode node) {
        return new MemberName(node.name, node.descriptor);
    }

    public static List<MemberName> fromRecordComponents(List<RecordComponentNode> nodes) {
        if (nodes == null) {
            return Collections.emptyList();
        }
        ArrayList<MemberName> result = new ArrayList<MemberName>(nodes.size());
        for (RecordComponentNode node : nodes) {
            result.add(MemberName.fromRecordComponent(node));
        }
        return result;
    }

    public static MemberName fromField(FieldNode node) {
        return new MemberName(node.name, node.desc);
    }

    public static List<MemberName> fromFields(List<FieldNode> nodes) {
        if (nodes == null) {
            return Collections.emptyList();
        }
        ArrayList<MemberName> result = new ArrayList<MemberName>(nodes.size());
        for (FieldNode node : nodes) {
            result.add(MemberName.fromField(node));
        }
        return result;
    }

    public static MemberName fromMethod(MethodNode node) {
        return new MemberName(node.name, node.desc);
    }

    public static List<MemberName> fromMethods(List<MethodNode> nodes) {
        if (nodes == null) {
            return Collections.emptyList();
        }
        ArrayList<MemberName> result = new ArrayList<MemberName>(nodes.size());
        for (MethodNode node : nodes) {
            result.add(MemberName.fromMethod(node));
        }
        return result;
    }
}

