/*
 * Decompiled with CFR 0.152.
 */
package dev.rdh.createunlimited.lib.classdiff.util;

import java.util.AbstractList;
import java.util.Collection;
import java.util.Iterator;
import java.util.ListIterator;
import org.jetbrains.annotations.NotNull;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.InsnList;

public class InsnListAdapter
extends AbstractList<AbstractInsnNode> {
    private final InsnList list;

    public InsnListAdapter(InsnList list) {
        this.list = list;
    }

    public InsnList getList() {
        return this.list;
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public AbstractInsnNode get(int index) {
        if (index == 0) {
            return this.list.getFirst();
        }
        if (index == this.list.size() - 1) {
            return this.list.getLast();
        }
        return this.list.get(index);
    }

    @Override
    public boolean contains(Object o) {
        return o instanceof AbstractInsnNode && this.list.contains((AbstractInsnNode)o);
    }

    @Override
    public int indexOf(Object o) {
        return o instanceof AbstractInsnNode ? this.list.indexOf((AbstractInsnNode)o) : -1;
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.indexOf(o);
    }

    @Override
    public Iterator<AbstractInsnNode> iterator() {
        return this.list.iterator();
    }

    @Override
    public ListIterator<AbstractInsnNode> listIterator(int index) {
        return this.list.iterator(index);
    }

    @Override
    public Object[] toArray() {
        return this.list.toArray();
    }

    @Override
    public AbstractInsnNode set(int index, AbstractInsnNode element) {
        this.throwUnmodifiable();
        AbstractInsnNode old = this.list.get(index);
        this.list.set(old, element);
        return old;
    }

    @Override
    public boolean add(AbstractInsnNode abstractInsnNode) {
        this.throwUnmodifiable();
        this.list.add(abstractInsnNode);
        return true;
    }

    @Override
    public boolean addAll(@NotNull Collection<? extends AbstractInsnNode> c) {
        this.throwUnmodifiable();
        if (c instanceof InsnListAdapter) {
            this.list.add(((InsnListAdapter)c).list);
            return true;
        }
        return super.addAll(c);
    }

    @Override
    public void add(int index, AbstractInsnNode element) {
        this.throwUnmodifiable();
        if (index == 0) {
            this.list.insert(element);
        } else {
            this.list.insertBefore(this.list.get(index), element);
        }
    }

    @Override
    public boolean addAll(int index, Collection<? extends AbstractInsnNode> c) {
        this.throwUnmodifiable();
        if (c instanceof InsnListAdapter) {
            if (index == 0) {
                this.list.insert(((InsnListAdapter)c).list);
            } else {
                this.list.insertBefore(this.list.get(index), ((InsnListAdapter)c).list);
            }
            return true;
        }
        return super.addAll(index, c);
    }

    @Override
    public boolean remove(Object o) {
        this.throwUnmodifiable();
        if (!(o instanceof AbstractInsnNode)) {
            return false;
        }
        this.list.remove((AbstractInsnNode)o);
        return true;
    }

    @Override
    public AbstractInsnNode remove(int index) {
        this.throwUnmodifiable();
        AbstractInsnNode old = this.list.get(index);
        this.list.remove(old);
        return old;
    }

    @Override
    public void clear() {
        this.throwUnmodifiable();
        this.list.clear();
    }

    private void throwUnmodifiable() {
        throw new UnsupportedOperationException("InsnListAdapter is unmodifiable");
    }
}

