/*
 * Decompiled with CFR 0.152.
 */
package dev.rdh.createunlimited.lib.classdiff.util;

public class ByteReader {
    private final byte[] data;
    private int ptr;

    public ByteReader(byte[] data) {
        this.data = data;
    }

    public ByteReader(byte[] data, int ptr) {
        this.data = data;
        this.ptr = ptr;
    }

    public int pointer() {
        return this.ptr;
    }

    public void pointer(int at) {
        this.ptr = at;
    }

    public void skip(int amount) {
        this.ptr += amount;
    }

    public int readByte() {
        return this.data[this.ptr++] & 0xFF;
    }

    public int readShort() {
        return (this.data[this.ptr++] & 0xFF) << 8 | this.data[this.ptr++] & 0xFF;
    }

    public int readInt() {
        int offset = this.ptr;
        this.ptr += 4;
        return (this.data[offset] & 0xFF) << 24 | (this.data[offset + 1] & 0xFF) << 16 | (this.data[offset + 2] & 0xFF) << 8 | this.data[offset + 3] & 0xFF;
    }

    public long readLong() {
        return ((long)this.readInt() & 0xFFFFFFFFL) << 32 | (long)this.readInt() & 0xFFFFFFFFL;
    }

    public String readUtf8() {
        int length = this.readShort();
        char[] result = new char[length];
        int offset = this.ptr;
        int endOffset = offset + length;
        int strLength = 0;
        byte[] input = this.data;
        while (offset < endOffset) {
            byte currentByte;
            if (((currentByte = input[offset++]) & 0x80) == 0) {
                result[strLength++] = (char)(currentByte & 0x7F);
                continue;
            }
            if ((currentByte & 0xE0) == 192) {
                result[strLength++] = (char)(((currentByte & 0x1F) << 6) + (input[offset++] & 0x3F));
                continue;
            }
            result[strLength++] = (char)(((currentByte & 0xF) << 12) + ((input[offset++] & 0x3F) << 6) + (input[offset++] & 0x3F));
        }
        this.ptr = offset;
        return new String(result);
    }

    public byte[] readByteArray(byte[] byteArray, int offset, int length) {
        System.arraycopy(this.data, this.ptr, byteArray, offset, length);
        this.ptr += length;
        return byteArray;
    }

    public byte[] readByteArray(byte[] byteArray) {
        return this.readByteArray(byteArray, 0, byteArray.length);
    }
}

