/*
 * Decompiled with CFR 0.152.
 */
package dev.rdh.createunlimited.command;

import com.google.gson.JsonObject;
import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import dev.rdh.createunlimited.CreateUnlimited;
import dev.rdh.createunlimited.Util;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_2172;
import net.minecraft.class_2314;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_7157;
import org.jetbrains.annotations.NotNull;

public record EnumArgument<T extends Enum<T>>(Class<T> enumClass, boolean lowercase) implements ArgumentType<T>
{
    private static final Dynamic2CommandExceptionType INVALID_ENUM = new Dynamic2CommandExceptionType((object, object2) -> class_2561.method_43470((String)String.format("Invalid enum value '%s', expected one of: %s", object, object2)));

    public static void init() {
        Util.registerArgument(EnumArgument.class, new Info(), CreateUnlimited.asResource("enumargument"));
    }

    public static <R extends Enum<R>> EnumArgument<R> enumArg(Class<R> clazz, boolean bl) {
        return new EnumArgument<R>(clazz, bl);
    }

    public T parse(StringReader stringReader) throws CommandSyntaxException {
        String string = stringReader.readUnquotedString();
        try {
            return Enum.valueOf(this.enumClass, this.unlowercase(string));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw INVALID_ENUM.createWithContext((ImmutableStringReader)stringReader, (Object)string, (Object)Arrays.toString(Arrays.stream((Enum[])this.enumClass.getEnumConstants()).map(Enum::name).map(this::lowercase).toArray()));
        }
    }

    public static <R extends Enum<R>> R getEnum(CommandContext<?> commandContext, String string, Class<R> clazz) {
        return (R)((Enum)commandContext.getArgument(string, clazz));
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> commandContext, SuggestionsBuilder suggestionsBuilder) {
        return class_2172.method_9264(Stream.of((Enum[])this.enumClass.getEnumConstants()).map(Enum::name).map(this::lowercase), (SuggestionsBuilder)suggestionsBuilder);
    }

    public Collection<String> getExamples() {
        return Stream.of((Enum[])this.enumClass.getEnumConstants()).map(Enum::name).map(this::lowercase).collect(Collectors.toList());
    }

    private String lowercase(String string) {
        return this.lowercase ? string.toLowerCase() : string;
    }

    private String unlowercase(String string) {
        if (!this.lowercase) {
            return string;
        }
        return Arrays.stream((Enum[])this.enumClass.getEnumConstants()).map(Enum::name).filter(string2 -> string2.equalsIgnoreCase(string)).findFirst().orElse(string);
    }

    public static class Info<T extends Enum<T>>
    implements class_2314<EnumArgument<T>, Template> {
        public void serializeToNetwork(Template template, class_2540 class_25402) {
            class_25402.method_10814(template.enumClass.getName());
            class_25402.writeBoolean(template.lowercase);
        }

        public Template deserializeFromNetwork(class_2540 class_25402) {
            try {
                String string = class_25402.method_19772();
                boolean bl = class_25402.readBoolean();
                return new Template(Class.forName(string), bl);
            }
            catch (ClassNotFoundException classNotFoundException) {
                return null;
            }
        }

        public void serializeToJson(Template template, JsonObject jsonObject) {
            jsonObject.addProperty("enum", template.enumClass.getName());
        }

        @NotNull
        public Template unpack(EnumArgument<T> enumArgument) {
            return new Template(enumArgument.enumClass, enumArgument.lowercase);
        }

        public class Template
        implements class_2314.class_7217<EnumArgument<T>> {
            final Class<T> enumClass;
            final boolean lowercase;

            Template(Class<T> clazz, boolean bl) {
                this.enumClass = clazz;
                this.lowercase = bl;
            }

            @NotNull
            public EnumArgument<T> instantiate(@NotNull class_7157 class_71572) {
                return new EnumArgument(this.enumClass, this.lowercase);
            }

            @NotNull
            public class_2314<EnumArgument<T>, ?> method_41728() {
                return Info.this;
            }
        }
    }
}

