/*
 * Decompiled with CFR 0.152.
 */
package dev.rdh.createunlimited.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import dev.rdh.createunlimited.CreateUnlimited;
import dev.rdh.createunlimited.command.CUCommands;
import dev.rdh.createunlimited.command.EnumArgument;
import dev.rdh.createunlimited.config.CUConfig;
import java.lang.reflect.Field;
import net.createmod.catnip.config.ConfigBase;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraftforge.common.ForgeConfigSpec;

public final class CUConfigCommand
extends CUCommands {
    private final boolean integrated;

    public CUConfigCommand(boolean bl) {
        this.integrated = bl;
    }

    @Override
    public ArgumentBuilder<class_2168, ?> register() {
        LiteralArgumentBuilder literalArgumentBuilder = class_2170.method_9247((String)"config");
        LiteralArgumentBuilder literalArgumentBuilder2 = null;
        for (Field field : CUConfig.class.getDeclaredFields()) {
            ForgeConfigSpec.ConfigValue configValue;
            ConfigBase.CValue cValue;
            if (!ConfigBase.CValue.class.isAssignableFrom(field.getType())) continue;
            String string = field.getName();
            if (field.getType() == ConfigBase.ConfigGroup.class) {
                if (literalArgumentBuilder2 != null) {
                    literalArgumentBuilder.then((ArgumentBuilder)literalArgumentBuilder2);
                }
                literalArgumentBuilder2 = class_2170.method_9247((String)string);
                literalArgumentBuilder.then(class_2170.method_9247((String)string).executes(commandContext -> {
                    CUConfigCommand.message((CommandContext<class_2168>)commandContext, CUConfig.getComment(string));
                    return 1;
                }));
                continue;
            }
            if (literalArgumentBuilder2 == null) {
                literalArgumentBuilder2 = literalArgumentBuilder;
            }
            try {
                cValue = (ConfigBase.CValue)field.get((Object)CUConfig.instance);
            }
            catch (ClassCastException | IllegalAccessException exception) {
                CreateUnlimited.LOGGER.error("Failed to get CValue for " + string, (Throwable)exception);
                continue;
            }
            try {
                Field field2 = ConfigBase.CValue.class.getDeclaredField("value");
                if (!field2.trySetAccessible()) {
                    CreateUnlimited.LOGGER.error("Could not access `value` field for {}", (Object)string);
                    continue;
                }
                configValue = (ForgeConfigSpec.ConfigValue)field2.get(cValue);
            }
            catch (ClassCastException | IllegalAccessException | NoSuchFieldException exception) {
                CreateUnlimited.LOGGER.error("Failed to get ConfigValue for " + string, (Throwable)exception);
                continue;
            }
            this.configure((LiteralArgumentBuilder<class_2168>)literalArgumentBuilder2, string, configValue);
        }
        if (literalArgumentBuilder2 != null) {
            literalArgumentBuilder.then(literalArgumentBuilder2);
        }
        return literalArgumentBuilder;
    }

    private boolean perms(class_2168 class_21682) {
        return this.integrated || class_21682.method_9259(2);
    }

    private <T> void configure(LiteralArgumentBuilder<class_2168> literalArgumentBuilder, String string, ForgeConfigSpec.ConfigValue<T> configValue) {
        Class<?> clazz = configValue.getDefault().getClass();
        literalArgumentBuilder.then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)string).executes(commandContext -> {
            CUConfigCommand.message((CommandContext<class_2168>)commandContext, string + ": " + CUConfig.getComment(string));
            CUConfigCommand.message((CommandContext<class_2168>)commandContext, "Current value: " + String.valueOf(configValue.get()));
            CUConfigCommand.message((CommandContext<class_2168>)commandContext, "Default value: " + String.valueOf(configValue.getDefault()));
            return 1;
        })).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"reset").requires(this::perms)).executes(commandContext -> {
            if (configValue.get().equals(configValue.getDefault())) {
                CUConfigCommand.error((CommandContext<class_2168>)commandContext, "Value is already default!");
                return 0;
            }
            configValue.set(configValue.getDefault());
            CUConfigCommand.message((CommandContext<class_2168>)commandContext, string + " reset to: " + String.valueOf(configValue.get()));
            configValue.save();
            return 1;
        }))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"value", this.getArgument(configValue)).requires(this::perms)).executes(commandContext -> {
            Object object = commandContext.getArgument("value", clazz);
            if (object == configValue.get()) {
                CUConfigCommand.error((CommandContext<class_2168>)commandContext, "Value is already set to " + String.valueOf(object));
                return 0;
            }
            configValue.set(object);
            CUConfigCommand.message((CommandContext<class_2168>)commandContext, "Value set to: " + String.valueOf(object));
            configValue.save();
            return 1;
        })));
    }

    private <T> ArgumentType<T> getArgument(ForgeConfigSpec.ConfigValue<T> configValue) {
        if (configValue instanceof ForgeConfigSpec.BooleanValue) {
            return BoolArgumentType.bool();
        }
        if (configValue instanceof ForgeConfigSpec.DoubleValue) {
            return DoubleArgumentType.doubleArg();
        }
        if (configValue instanceof ForgeConfigSpec.IntValue) {
            return IntegerArgumentType.integer();
        }
        Class<?> clazz = configValue.getDefault().getClass();
        if (configValue instanceof ForgeConfigSpec.EnumValue && clazz.isEnum()) {
            return EnumArgument.enumArg(clazz, true);
        }
        throw new IllegalArgumentException("Unsupported class for argument: " + String.valueOf(clazz));
    }
}

