/*
 * Decompiled with CFR 0.152.
 */
package dev.rdh.createunlimited.boot;

import dev.rdh.createunlimited.lib.classdiff.ClassPatcher;
import dev.rdh.createunlimited.lib.classdiff.format.DiffReader;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.commons.ClassRemapper;
import org.objectweb.asm.commons.Remapper;
import org.objectweb.asm.commons.SimpleRemapper;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.spongepowered.asm.launch.platform.container.IContainerHandle;
import org.spongepowered.asm.logging.ILogger;
import org.spongepowered.asm.mixin.MixinEnvironment;
import org.spongepowered.asm.mixin.extensibility.IMixinConfig;
import org.spongepowered.asm.mixin.extensibility.IMixinConfigPlugin;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;
import org.spongepowered.asm.mixin.transformer.IMixinTransformer;
import org.spongepowered.asm.mixin.transformer.ext.Extensions;
import org.spongepowered.asm.mixin.transformer.ext.IExtension;
import org.spongepowered.asm.mixin.transformer.ext.ITargetClassContext;
import org.spongepowered.asm.service.IClassBytecodeProvider;
import org.spongepowered.asm.service.IClassProvider;
import org.spongepowered.asm.service.IClassTracker;
import org.spongepowered.asm.service.IMixinAuditTrail;
import org.spongepowered.asm.service.IMixinInternal;
import org.spongepowered.asm.service.IMixinService;
import org.spongepowered.asm.service.ITransformerProvider;
import org.spongepowered.asm.service.MixinService;
import org.spongepowered.asm.util.ReEntranceLock;
import sun.misc.Unsafe;

public abstract class Transformer
implements IMixinService,
IClassBytecodeProvider,
IExtension,
IMixinConfigPlugin {
    private static final ILogger LOGGER = MixinService.getService().getLogger("CreateUnlimited/Boot");
    private final ClassLoader CL = this.getClass().getClassLoader();
    private IMixinService serviceDelegate;
    private IClassBytecodeProvider bytecodeDelegate;
    private final Map<String, ClassNode> classes = new HashMap<String, ClassNode>();
    private boolean bootstrapped = false;
    private String mixinPackage;
    private static final Unsafe U = Transformer.getUnsafe();
    private static final MethodHandles.Lookup L = Transformer.getImplLookup();
    public final String platform = this.getPlatform();
    private final Map<String, byte[]> patches = this.getPatches();

    protected Transformer() {
        LOGGER.info("Loading Transformer...", new Object[0]);
        LOGGER.info("Class: {}, loader: {}", new Object[]{this.getClass().getName(), this.CL});
        LOGGER.info("Platform: {}", new Object[]{this.platform});
    }

    public String getName() {
        return this.serviceDelegate.getName();
    }

    public boolean isValid() {
        return this.serviceDelegate.isValid();
    }

    public void prepare() {
        this.serviceDelegate.prepare();
    }

    public MixinEnvironment.Phase getInitialPhase() {
        return this.serviceDelegate.getInitialPhase();
    }

    public void offer(IMixinInternal internal) {
        this.serviceDelegate.offer(internal);
    }

    public void init() {
        this.serviceDelegate.init();
    }

    public void beginPhase() {
        this.serviceDelegate.beginPhase();
    }

    public void checkEnv(Object bootSource) {
        this.serviceDelegate.checkEnv(bootSource);
    }

    public ReEntranceLock getReEntranceLock() {
        return this.serviceDelegate.getReEntranceLock();
    }

    public IClassProvider getClassProvider() {
        return this.serviceDelegate.getClassProvider();
    }

    public IClassBytecodeProvider getBytecodeProvider() {
        this.bytecodeDelegate = this.serviceDelegate.getBytecodeProvider();
        return this;
    }

    public ITransformerProvider getTransformerProvider() {
        return this.serviceDelegate.getTransformerProvider();
    }

    public IClassTracker getClassTracker() {
        return this.serviceDelegate.getClassTracker();
    }

    public IMixinAuditTrail getAuditTrail() {
        return this.serviceDelegate.getAuditTrail();
    }

    public Collection<String> getPlatformAgents() {
        return this.serviceDelegate.getPlatformAgents();
    }

    public IContainerHandle getPrimaryContainer() {
        return this.serviceDelegate.getPrimaryContainer();
    }

    public Collection<IContainerHandle> getMixinContainers() {
        return this.serviceDelegate.getMixinContainers();
    }

    public InputStream getResourceAsStream(String name) {
        return this.serviceDelegate.getResourceAsStream(name);
    }

    public String getSideName() {
        return this.serviceDelegate.getSideName();
    }

    public MixinEnvironment.CompatibilityLevel getMinCompatibilityLevel() {
        return this.serviceDelegate.getMinCompatibilityLevel();
    }

    public MixinEnvironment.CompatibilityLevel getMaxCompatibilityLevel() {
        return this.serviceDelegate.getMaxCompatibilityLevel();
    }

    public ILogger getLogger(String name) {
        return this.serviceDelegate.getLogger(name);
    }

    public boolean addClass(ClassNode classNode) {
        return this.classes.putIfAbsent(classNode.name.replace('/', '.'), classNode) == null;
    }

    public ClassNode getClassNode(String name) throws ClassNotFoundException, IOException {
        ClassNode classNode = this.classes.get(name);
        if (classNode != null) {
            return classNode;
        }
        return this.bytecodeDelegate.getClassNode(name);
    }

    public ClassNode getClassNode(String name, boolean runTransformers) throws ClassNotFoundException, IOException {
        ClassNode classNode = this.classes.get(name);
        if (classNode != null) {
            return classNode;
        }
        return this.bytecodeDelegate.getClassNode(name, runTransformers);
    }

    public ClassNode getClassNode(String name, boolean runTransformers, int readerFlags) throws ClassNotFoundException, IOException {
        ClassNode classNode = this.classes.get(name);
        if (classNode != null) {
            return classNode;
        }
        return this.bytecodeDelegate.getClassNode(name, runTransformers, readerFlags);
    }

    private void extensionBootstrap() {
        if (this.bootstrapped) {
            return;
        }
        this.bootstrapped = true;
        LOGGER.info("Bootstrapping Transformer as IExtension...", new Object[0]);
        IMixinTransformer transformer = (IMixinTransformer)MixinEnvironment.getCurrentEnvironment().getActiveTransformer();
        Extensions extensions = (Extensions)transformer.getExtensions();
        extensions.add((IExtension)this);
    }

    public boolean checkActive(MixinEnvironment environment) {
        return true;
    }

    public void preApply(ITargetClassContext context) {
        this.transform(context.getClassNode());
    }

    public void postApply(ITargetClassContext context) {
    }

    public void export(MixinEnvironment env, String name, boolean force, ClassNode classNode) {
    }

    public void onLoad(String mixinPackage) {
        this.mixinPackage = mixinPackage;
        this.extensionBootstrap();
    }

    public String getRefMapperConfig() {
        return null;
    }

    public boolean shouldApplyMixin(String targetClassName, String mixinClassName) {
        return mixinClassName.endsWith("$Patched") || !this.patches.containsKey(mixinClassName);
    }

    public void acceptTargets(Set<String> myTargets, Set<String> otherTargets) {
        Class<?> myTargetsClass = myTargets.getClass();
        Map backingTargets = null;
        for (Field field : myTargetsClass.getDeclaredFields()) {
            if (!Map.class.isAssignableFrom(field.getType()) || !field.isSynthetic()) continue;
            backingTargets = (Map)Transformer.getField(field, myTargets);
            break;
        }
        if (backingTargets == null) {
            StringBuilder sb = new StringBuilder("Failed to find backing map of Set class ").append(myTargetsClass.getName()).append('\n').append("Fields:").append('\n');
            for (Field field : myTargetsClass.getDeclaredFields()) {
                sb.append('\t').append(field.getName()).append(": ").append(field.getType().getName());
                if (field.isSynthetic()) {
                    sb.append(" (synthetic)");
                }
                sb.append('\n');
            }
            throw new NoSuchFieldException(sb.toString());
        }
        for (String className : this.getTransformedClasses()) {
            backingTargets.putIfAbsent(className, new ArrayList());
        }
    }

    private void injectService() {
        MixinService service = L.unreflect(MixinService.class.getDeclaredMethod("getInstance", new Class[0])).invokeExact();
        Field f = MixinService.class.getDeclaredField("service");
        IMixinService s = (IMixinService)Transformer.getField(f, service);
        if (s == this) {
            return;
        }
        LOGGER.info("Bootstrapping Transformer as IMixinService...", new Object[0]);
        this.serviceDelegate = s;
        Transformer.setField(f, service, this);
        Object transformer = MixinEnvironment.getCurrentEnvironment().getActiveTransformer();
        Object processor = Transformer.getField(transformer.getClass().getDeclaredField("processor"), transformer);
        Transformer.setField(processor.getClass().getDeclaredField("service"), processor, this);
        List configs = (List)Transformer.getField(processor.getClass().getDeclaredField("pendingConfigs"), processor);
        for (IMixinConfig config : configs) {
            if (config.getPlugin() != this) continue;
            Transformer.setField(config.getClass().getDeclaredField("service"), config, this);
            break;
        }
    }

    public List<String> getMixins() {
        this.injectService();
        return this.getTransformedMixins(this.mixinPackage);
    }

    public void postApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    public void preApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    private static Unsafe getUnsafe() {
        for (Field field : Unsafe.class.getDeclaredFields()) {
            if (field.getType() != Unsafe.class) continue;
            field.setAccessible(true);
            return (Unsafe)field.get(null);
        }
        throw new RuntimeException("Unsafe not found");
    }

    private static MethodHandles.Lookup getImplLookup() {
        return (MethodHandles.Lookup)Transformer.getField(MethodHandles.Lookup.class.getDeclaredField("IMPL_LOOKUP"), null);
    }

    private static <T> T getField(Field field, Object instance) {
        long offset;
        Object base;
        if (Modifier.isStatic(field.getModifiers())) {
            if (instance != null) {
                throw new IllegalArgumentException("Instance must be null for static fields");
            }
            base = U.staticFieldBase(field);
            offset = U.staticFieldOffset(field);
        } else {
            if (instance == null) {
                throw new IllegalArgumentException("Instance must not be null for non-static fields");
            }
            base = instance;
            offset = U.objectFieldOffset(field);
        }
        return (T)U.getObject(base, offset);
    }

    private static <T> void setField(Field field, Object instance, T value) {
        long offset;
        Object base;
        if (!field.getType().isAssignableFrom(value.getClass())) {
            throw new IllegalArgumentException("Value type " + String.valueOf(value.getClass()) + " does not match field type " + String.valueOf(field.getType()));
        }
        if (Modifier.isStatic(field.getModifiers())) {
            if (instance != null) {
                throw new IllegalArgumentException("Instance must be null for static fields");
            }
            base = U.staticFieldBase(field);
            offset = U.staticFieldOffset(field);
        } else {
            if (instance == null) {
                throw new IllegalArgumentException("Instance must not be null for non-static fields");
            }
            base = instance;
            offset = U.objectFieldOffset(field);
        }
        U.putObject(base, offset, value);
    }

    private boolean isClassLoaded(String className) {
        MethodHandle mh = L.unreflect(ClassLoader.class.getDeclaredMethod("findLoadedClass", String.class)).bindTo(this.CL);
        return mh.invokeExact(className) != null;
    }

    protected void loadClass(ClassNode classNode) {
        ClassWriter cw = new ClassWriter(1);
        classNode.accept((ClassVisitor)cw);
        byte[] classBytes = cw.toByteArray();
        MethodHandle mh = L.unreflect(ClassLoader.class.getDeclaredMethod("defineClass", String.class, byte[].class, Integer.TYPE, Integer.TYPE)).bindTo(this.CL);
        Class c = mh.invokeExact(classNode.name.replace('/', '.'), classBytes, 0, classBytes.length);
    }

    protected void earlyBoot(String name) {
        ClassNode n = MixinService.getService().getBytecodeProvider().getClassNode(name.replace(".", "/"));
        this.transform(n);
        this.loadClass(n);
    }

    protected abstract String getPlatform();

    private Map<String, byte[]> getPatches() {
        ZipEntry entry;
        HashMap<String, byte[]> patches = new HashMap<String, byte[]>();
        if (!this.CL.getResources("META-INF/patches.zip").hasMoreElements()) {
            LOGGER.info("No patches found", new Object[0]);
            return patches;
        }
        ZipInputStream in = new ZipInputStream(this.CL.getResourceAsStream("META-INF/patches.zip"));
        while ((entry = in.getNextEntry()) != null) {
            String[] split = entry.getName().split("/", 2);
            String platformName = split[0];
            if (!platformName.equals(this.platform)) continue;
            if (!split[1].endsWith(".class.diff")) {
                throw new IllegalStateException("Unsupported file name: " + platformName);
            }
            String className = split[1].substring(0, split[1].length() - ".class.diff".length()).replace('/', '.');
            byte[] bytes = in.readAllBytes();
            patches.put(className, bytes);
        }
        LOGGER.info("Loaded {} patches for platform {}", new Object[]{patches.size(), this.platform});
        return patches;
    }

    protected Set<String> getTransformedClasses() {
        HashSet<String> transformedClasses = new HashSet<String>();
        for (String className : this.patches.keySet()) {
            if (this.isClassLoaded(className)) {
                LOGGER.warn("Class {} is already loaded, skipping patch", new Object[]{className});
                continue;
            }
            byte[] classBytes = this.CL.getResourceAsStream(className.replace('.', '/') + ".class").readAllBytes();
            ClassNode classNode = new ClassNode();
            new ClassReader(classBytes).accept((ClassVisitor)classNode, 2);
            if (Transformer.hasMixin(classNode)) continue;
            transformedClasses.add(className);
        }
        return transformedClasses;
    }

    private List<String> getTransformedMixins(String packag) {
        ArrayList<String> mixins = new ArrayList<String>();
        for (String className : this.patches.keySet()) {
            byte[] classBytes = this.CL.getResourceAsStream(className.replace('.', '/') + ".class").readAllBytes();
            ClassNode classNode = new ClassNode();
            new ClassReader(classBytes).accept((ClassVisitor)classNode, 0);
            if (!Transformer.hasMixin(classNode)) continue;
            if (!className.startsWith(packag)) {
                LOGGER.warn("found mixin {} outside package {}", new Object[]{className, packag});
                continue;
            }
            this.transform(classNode);
            SimpleRemapper remapper = new SimpleRemapper(classNode.name, classNode.name + "$Patched");
            ClassNode remapped = new ClassNode();
            classNode.accept((ClassVisitor)new ClassRemapper((ClassVisitor)remapped, (Remapper)remapper));
            classNode = remapped;
            if (!this.addClass(classNode)) {
                LOGGER.warn("Failed to add mixin class {} to Transformer", new Object[]{classNode.name});
            }
            mixins.add(classNode.name.replace('/', '.').substring(packag.length() + 1));
        }
        LOGGER.info("Loaded {} mixins for package {}", new Object[]{mixins.size(), packag});
        return mixins;
    }

    private static boolean hasMixin(ClassNode classNode) {
        if (classNode.invisibleAnnotations == null) {
            return false;
        }
        for (AnnotationNode annotationNode : classNode.invisibleAnnotations) {
            if (!annotationNode.desc.equals("Lorg/spongepowered/asm/mixin/Mixin;")) continue;
            return true;
        }
        return false;
    }

    public void transform(ClassNode node) {
        byte[] patch = this.patches.get(node.name.replace('/', '.'));
        if (patch == null) {
            return;
        }
        LOGGER.info("patching {}", new Object[]{node.name});
        try {
            ClassPatcher.patch(node, new DiffReader(patch));
        }
        catch (Exception e) {
            LOGGER.error("Failed to patch class " + node.name, (Throwable)e);
            Path p = Path.of("patch-error-" + node.name.replace('/', '_') + ".class", new String[0]);
            ClassWriter cw = new ClassWriter(1);
            node.accept((ClassVisitor)cw);
            Files.write(p, cw.toByteArray(), new OpenOption[0]);
            Files.write(Path.of(p.toString() + ".diff", new String[0]), patch, new OpenOption[0]);
        }
    }
}

